WITH Swap_Generic;
PROCEDURE Sort_DelayedSelection_Generic(List: IN OUT ListType) IS
------------------------------------------------------------------------
--| Body of generic Delayed Selection Sort
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: January 1996                                     
------------------------------------------------------------------------

  PROCEDURE Exchange IS NEW Swap_Generic(ValueType => ElementType);
  
  IndexOfMin: IndexType;
  
BEGIN -- Sort_DelayedSelection_Generic

  FOR PositionToFill IN List'First..List'Last - 1 LOOP
  
    IndexOfMin := PositionToFill;

    FOR ItemToCompare IN PositionToFill + 1..List'Last LOOP
      IF KeyOf(List(ItemToCompare)) < KeyOf(List(IndexOfMin)) THEN
        IndexOfMin := ItemToCompare;
      END IF;
    END LOOP;

    Exchange(List(PositionToFill), List(IndexOfMin));

  END LOOP;

END Sort_DelayedSelection_Generic;
