WITH VStrings; USE VStrings;
FUNCTION RPN_Simple (X : IN VString) RETURN VString IS
-- Pre:  X is defined and represents an arithmetic expression
--   with single-letter variable names
-- Post: returns the RPN_Simple of X; no operator priorities are taken
--   into account.

  C      : Character;
  T      : VString(MaxLength(X)) := X;
  Op     : Character := ' ';
  Result : VString(MaxLength(X));  -- empty by default

BEGIN -- RPN_Simple

  IF NOT IsEmpty (T) THEN
    LOOP
      C := Head (T);

      CASE C IS
	WHEN 'A' .. 'Z' | 'a' .. 'z' | '0' .. '9' =>
	  Result := Result & C;

	WHEN '+' | '-' | '*' | '/' =>
	  IF Op = ' ' THEN         -- first operator seen
	    Op := C;
	  ELSE
	    Result := Result & Op; -- get rid of old op
	    Op := C;
	  END IF;
	WHEN OTHERS =>
	  NULL;                    -- skip bad character
      END CASE;

      T := Tail (T);
      EXIT WHEN IsEmpty (T);
    END LOOP;

    Result := Result & Op;

    RETURN Result;
  END IF;

END RPN_Simple;
