WITH Ada.Calendar; USE Ada.Calendar;
PACKAGE BODY CPUClock IS
------------------------------------------------------------------
--|                                                              
--| This body is compatible with Ada compilers whose output
--| runs on single-user IBM-PC-family and Apple Macintosh computers
--|                                                              
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: October 1995                                     
--|                                                              
------------------------------------------------------------------

  SavedTime : Ada.Calendar.Time;

  PROCEDURE ResetCPUTime IS
  BEGIN
    SavedTime := Ada.Calendar.Clock;
  END ResetCPUTime;

  FUNCTION CPUTime RETURN CPUSecond IS
  BEGIN
    RETURN CPUSecond (Ada.Calendar."-"(Ada.Calendar.Clock,SavedTime));
  END CPUTime;

BEGIN -- initialization of package

  -- this statement is executed once, when the package is elaborated, 
  -- i.e., just before its client program starts executing

  ResetCPUTime;

END CPUClock;
