import java.awt.*;
import java.util.*;

/*

INSTRUCTIONS


In this homework you will write some files that process a folder full of images of ducks. These images are available in the current directory.


Complete the following steps:

1. Examine the tests below, and search for all methods that are missing from the DuckImage.java file in this directory. Add those method skeletons to that file. 
Repeat these steps with ImageFolder.java. Your code should now compile against the tests, even though it doesn't pass any of them.

2. Examine the test cases below; there are five of them. For each one, explain, in English, what they are testing in the comments provided. Then, write the 6th test 
case as requested (it will be similar to test 3). Note that these tests refer to existing images and text files in the current directory.

3. Examine the ImageFunctions.java file, which contains a bunch of helper methods used throughout this project, including ones you will call. For each of the three
methods, give an English explanaton of how it uses its arguments to calculate the value(s) being returned. A lot of the code there has not been covered in class
this semester; use Google/ChatGPT/etc to figure out what the individual lines of code do, then summarize the methods in your own words.

4. Complete the bodies of all the skeleton methods in DuckImage and ImageFolder so that your code passes all of the tests. For the greyscale method, see the webpage
for these homework instructions for more information.

5. Tar your code with:
	tar -cvf hw11.tar *.*
and then upload your file to BB.

*/

public class Tester{

	public static void main(String[] args){

		// TEST 1 ************************************************************************************************************************
		// explanation:

		String[] duck_files = new String[5];
		duck_files[0] = "mandarin.jpg";
		duck_files[1] = "wood.jpeg";
		duck_files[2] = "harlequin.jpeg";
		duck_files[3] = "pintail.jpg";
		duck_files[4] = "mallard.jpeg";
		ImageFolder ducks = new ImageFolder(duck_files);

		System.out.println("test1a: " + ducks.getFile(0).getName().equals("mandarin.jpg"));
		System.out.println("test1b: " + ducks.getFile(1).getName().equals("wood.jpeg"));
		System.out.println("test1c: " + ducks.getFile(2).getName().equals("harlequin.jpeg"));
		System.out.println("test1d: " + ducks.getFile(3).getName().equals("pintail.jpg"));
		System.out.println("test1e: " + ducks.getFile(4).getName().equals("mallard.jpeg"));

		// TEST 2 ************************************************************************************************************************
		// explanation:

		DuckImage mandarin = ducks.getFile(0);
		ImageFunctions.createImage("mandarin_check.png", mandarin);

		int[] reds_firstRow = { 186, 186, 186, 186, 186, 186, 186, 186, 187, 185, 183, 181, 180, 180, 180, 180, 179, 180, 181, 182, 181, 181, 183, 183, 185, 184, 181, 179, 177, 173, 169, 166, 162, 159, 156, 153, 150, 145, 142, 140, 137, 135, 131, 129, 129, 130, 130, 130, 130, 133, 136, 139, 141, 144, 148, 151, 154, 155, 155, 156, 157, 157, 158, 159, 157, 155, 152, 150, 150, 148, 146, 143, 143, 142, 144, 144, 147, 150, 155, 157, 162, 165, 168, 171, 174, 176, 180, 182, 181, 181, 181, 182, 182, 182, 183, 184, 186, 186, 187, 187, 187, 187, 189, 190, 189, 190, 190, 190, 189, 188, 187, 186, 180, 177, 174, 170, 167, 163, 157, 153, 148, 145, 141, 138, 137, 137, 138, 138, 137, 137, 137, 137, 137, 137, 138, 138, 137, 138, 140, 140, 141, 141, 142, 142, 140, 140, 140, 139, 137, 136, 136, 136, 136, 136, 137, 136, 136, 135, 134, 134, 134, 134, 131, 129, 126, 123, 120, 118, 116, 113, 111, 110, 111, 112, 113, 113, 113, 112, 114, 116, 116, 118, 121, 122, 125, 126, 128, 129, 133, 137, 141, 143, 148, 151, 154, 156, 156, 155, 154, 153, 153, 150, 149, 147, 146, 144, 142, 141, 143, 143, 144, 143, 143, 143, 144, 145, 143, 142, 141, 138, 136, 132, 129, 127, 125, 125, 125, 124, 123, 123, 123, 123, 121, 120, 117, 113, 109, 105, 102, 101, 105, 105, 105, 105, 104, 104, 105, 106, 106, 109, 113, 118, 124, 126, 126, 127, 127, 128, 130, 132, 130, 130, 131, 131, 126, 124, 124, 123, 120, 117, 113, 109, 113, 113, 114, 115, 115, 115, 115, 115, 116, 115, 112, 109, 106, 105, 106, 106, 110, 114, 119, 121, 130, 131, 136, 139, 141, 145, 150, 152};
		int[] greens_firstRow = { 188, 188, 188, 188, 187, 187, 187, 187, 189, 187, 185, 184, 183, 184, 184, 184, 183, 184, 185, 186, 185, 185, 185, 185, 187, 186, 186, 184, 182, 178, 176, 173, 170, 168, 165, 162, 160, 155, 153, 151, 147, 145, 141, 139, 139, 140, 140, 140, 140, 143, 146, 150, 152, 155, 159, 163, 166, 167, 167, 168, 170, 170, 171, 172, 170, 168, 165, 163, 163, 162, 160, 157, 157, 157, 156, 157, 160, 163, 167, 168, 170, 173, 176, 180, 182, 185, 188, 190, 190, 190, 190, 192, 192, 192, 193, 194, 193, 193, 194, 194, 194, 194, 196, 197, 196, 197, 196, 196, 195, 194, 193, 192, 189, 186, 182, 178, 175, 171, 166, 162, 156, 153, 150, 147, 146, 146, 147, 147, 145, 145, 146, 146, 146, 146, 148, 148, 147, 148, 150, 150, 151, 151, 152, 152, 152, 152, 152, 151, 149, 148, 147, 147, 144, 144, 144, 143, 143, 141, 140, 140, 140, 140, 140, 138, 134, 131, 130, 128, 128, 125, 123, 122, 123, 124, 126, 125, 125, 124, 126, 129, 129, 131, 135, 136, 140, 141, 144, 146, 147, 151, 155, 157, 160, 163, 167, 169, 169, 169, 168, 168, 168, 165, 161, 159, 158, 156, 155, 154, 156, 156, 156, 155, 154, 154, 153, 153, 151, 150, 149, 147, 143, 140, 137, 136, 135, 135, 135, 134, 133, 133, 133, 133, 131, 129, 126, 121, 117, 112, 109, 107, 110, 110, 109, 109, 107, 107, 107, 108, 108, 111, 115, 121, 127, 130, 130, 132, 132, 134, 136, 139, 137, 138, 139, 139, 134, 132, 134, 133, 130, 127, 123, 119, 122, 122, 123, 124, 123, 123, 122, 122, 123, 122, 117, 114, 111, 110, 111, 112, 113, 118, 123, 126, 134, 135, 141, 145, 145, 150, 155, 157};
		int[] blues_firstRow = { 166, 166, 167, 167, 169, 169, 169, 169, 168, 165, 161, 155, 152, 149, 149, 147, 146, 147, 148, 149, 148, 148, 148, 148, 150, 149, 146, 144, 142, 138, 135, 131, 121, 115, 112, 105, 100, 92, 87, 82, 78, 74, 68, 66, 66, 67, 67, 67, 69, 72, 73, 74, 76, 76, 80, 81, 82, 83, 81, 82, 82, 82, 83, 84, 80, 78, 75, 71, 71, 67, 63, 59, 59, 54, 54, 52, 54, 57, 59, 63, 67, 70, 73, 73, 71, 70, 69, 68, 65, 61, 61, 61, 59, 59, 60, 61, 61, 61, 62, 62, 64, 64, 66, 67, 67, 68, 70, 70, 69, 68, 67, 66, 64, 61, 60, 56, 56, 52, 49, 45, 44, 41, 41, 38, 41, 41, 42, 42, 42, 42, 41, 39, 39, 37, 36, 36, 34, 35, 37, 37, 39, 39, 40, 40, 42, 42, 42, 41, 39, 38, 42, 42, 43, 43, 48, 48, 50, 51, 52, 52, 50, 50, 51, 49, 48, 45, 44, 42, 42, 39, 37, 36, 37, 38, 38, 39, 41, 40, 42, 41, 41, 39, 40, 38, 39, 36, 37, 34, 36, 38, 41, 43, 48, 51, 53, 53, 53, 48, 47, 43, 43, 38, 33, 31, 30, 28, 24, 23, 25, 25, 30, 31, 32, 36, 38, 41, 40, 39, 37, 32, 27, 19, 15, 11, 13, 13, 13, 12, 11, 11, 11, 11, 9, 10, 9, 9, 8, 8, 6, 9, 16, 20, 22, 25, 26, 30, 32, 35, 35, 36, 40, 42, 46, 45, 45, 42, 38, 36, 36, 35, 31, 27, 28, 27, 22, 20, 21, 20, 18, 15, 11, 7, 13, 13, 14, 15, 14, 14, 16, 16, 17, 16, 14, 11, 8, 7, 8, 6, 8, 8, 12, 10, 14, 12, 12, 11, 8, 8, 13, 13 };

		System.out.println("test2a: " + Arrays.equals(mandarin.getReds()[0], reds_firstRow));
		System.out.println("test2b: " + Arrays.equals(mandarin.getGreens()[0], greens_firstRow));
		System.out.println("test2c: " + Arrays.equals(mandarin.getBlues()[0], blues_firstRow));

		// TEST 3 ************************************************************************************************************************
		// explanation:

		DuckImage mallard = ducks.getFile(4);
		mallard.flipHorizontal();
		ImageFunctions.createImage("flipped_horiz_mallard.png", mallard);
		//mallard.writePixelsToFile("flipped_horiz_mallard.txt");

		String reds = ImageFunctions.loadPixelChannel("flipped_horiz_mallard.txt", "red");
		String greens = ImageFunctions.loadPixelChannel("flipped_horiz_mallard.txt", "green");
		String blues = ImageFunctions.loadPixelChannel("flipped_horiz_mallard.txt", "blue");

		System.out.println("test3a: " + reds.equals(Arrays.deepToString(mallard.getReds())));
		System.out.println("test3b: " + greens.equals(Arrays.deepToString(mallard.getGreens())));
		System.out.println("test3c: " + blues.equals(Arrays.deepToString(mallard.getBlues())));


		// TEST 4 ************************************************************************************************************************
		// explanation:

		DuckImage wood = ducks.getFile(1);
		wood.greyscale();
		ImageFunctions.createImage("grey_wood.png", wood);
		//wood.writePixelsToFile("grey_wood.txt");

		reds = ImageFunctions.loadPixelChannel("grey_wood.txt", "red");
		greens = ImageFunctions.loadPixelChannel("grey_wood.txt", "green");
		blues = ImageFunctions.loadPixelChannel("grey_wood.txt", "blue");

		System.out.println("test4a: " + reds.equals(Arrays.deepToString(wood.getReds())));
		System.out.println("test4b: " + greens.equals(Arrays.deepToString(wood.getGreens())));
		System.out.println("test4c: " + blues.equals(Arrays.deepToString(wood.getBlues())));

		// TEST 5 ************************************************************************************************************************
		// explanation:

		DuckImage average = ducks.averageImages();
		ImageFunctions.createImage("average_ducks.png", average);
		//average.writePixelsToFile("average_ducks.txt");

		reds = ImageFunctions.loadPixelChannel("average_ducks.txt", "red");
		greens = ImageFunctions.loadPixelChannel("average_ducks.txt", "green");
		blues = ImageFunctions.loadPixelChannel("average_ducks.txt", "blue");

		System.out.println("test5a: " + reds.equals(Arrays.deepToString(average.getReds())));
		System.out.println("test5b: " + greens.equals(Arrays.deepToString(average.getGreens())));
		System.out.println("test5c: " + blues.equals(Arrays.deepToString(average.getBlues())));

		// TEST 6 ************************************************************************************************************************

		//write your own test case below for flipVertical with the pintail duck
		// you can assume the file of pixel channels for the result exists, in a file called "flipped_vertical_pintail.txt"

	}



}