import java.awt.image.BufferedImage;
import java.io.*;
import javax.imageio.ImageIO;

public class ImageFunctions {

    // explanation: 
    public static String loadPixelChannel(String filepath, String color){
        try{
            BufferedReader reader = new BufferedReader(new FileReader(filepath));
            String reds = reader.readLine();
            String greens = reader.readLine();
            String blues = reader.readLine();
            
            if (color.equals("red"))
                return reds;
            else if (color.equals("green"))
                return greens;
            else 
                return blues;

        } catch (Exception e){
            System.out.println("error writing to " + filepath);
        }

        return null;
    }

    // explanation: 
    public static int[][] getChannel(String filepath, String color){

        BufferedImage originalImage = null;
        try{
            originalImage = ImageIO.read(new File("./" + filepath));   
        } catch (Exception e){
            System.out.println("error with file " + filepath);
            System.out.println(originalImage);
            e.printStackTrace();
        }
    
        int width = originalImage.getWidth();
        int height = originalImage.getHeight();

        BufferedImage redChannelImage = new BufferedImage(width, height, BufferedImage.TYPE_INT_RGB);
        BufferedImage greenChannelImage = new BufferedImage(width, height, BufferedImage.TYPE_INT_RGB);
        BufferedImage blueChannelImage = new BufferedImage(width, height, BufferedImage.TYPE_INT_RGB);

        int[][] reds = new int[height][width];
        int[][] greens = new int[height][width];
        int[][] blues = new int[height][width];

        for (int row = 0; row < height; row++) {
            for (int col = 0; col < width; col++) {
                int pixel = originalImage.getRGB(col, row);

                // Extract individual color components
                int alpha = (pixel >> 24) & 0xff; // Alpha is often included, but not always needed for channels
                int red = (pixel >> 16) & 0xff;
                int green = (pixel >> 8) & 0xff;
                int blue = pixel & 0xff;

                // Create new pixel values for each channel image
                // Set other channels to 0 to visualize only the desired channel
                int redPixel = (red << 16) | (0 << 8) | 0; // Only red component
                int greenPixel = (0 << 16) | (green << 8) | 0; // Only green component
                int bluePixel = (0 << 16) | (0 << 8) | blue; // Only blue component

                reds[row][col] = red;
                greens[row][col] = green;
                blues[row][col] = blue;
            }
        }

        if (color.equals("red"))
            return reds;
        else if (color.equals("green"))
            return greens;
        else 
            return blues;
    }

    // explanation: 
    public static void createImage(String path, DuckImage duck){

        int[][] redPixels = duck.getReds();
        int[][] greenPixels = duck.getGreens();
        int[][] bluePixels = duck.getBlues();


        int height = redPixels.length;
        int width = redPixels[0].length;

        // Create a BufferedImage
        BufferedImage image = new BufferedImage(width, height, BufferedImage.TYPE_INT_RGB);

        // Set the RGB values for each pixel in the BufferedImage
        for (int y = 0; y < height; y++) {
            for (int x = 0; x < width; x++) {
                int r = redPixels[y][x];
                int g = greenPixels[y][x];
                int b = bluePixels[y][x];

                // Combine R, G, B into a single integer pixel value
                int rgb = (r << 16) | (g << 8) | b;
                image.setRGB(x, y, rgb);
            }
        }

        // Save the image to a file
        try {
            File outputFile = new File(path);
            ImageIO.write(image, "png", outputFile);
            System.out.println("Image saved successfully to " + outputFile.getAbsolutePath());
        } catch (IOException e) {
            System.err.println("Error saving image: " + e.getMessage());
        }
    }
}
    

    