WITH Swap_Generic;
PROCEDURE Sort_SimpleSelection_Generic(List: IN OUT ListType) IS
------------------------------------------------------------------------
--| Procedure body for Sort_SimpleSelection_Generic
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: January 1996                                     
------------------------------------------------------------------------

  PROCEDURE Exchange IS NEW Swap_Generic(ValueType => ElementType);

BEGIN -- Sort_SimpleSelection_Generic

  FOR PositionToFill IN List'First..List'Last - 1 LOOP

    -- Store in List(PositionToFill) the "smallest" element remaining
    -- in the subarray List(PositionToFill + 1..List'Last)

    FOR ItemToCompare IN PositionToFill + 1..List'Last LOOP
      IF KeyOf(List(ItemToCompare)) < KeyOf(List(PositionToFill)) THEN
        Exchange(List(PositionToFill), List(ItemToCompare));
      END IF;
    END LOOP;

  END LOOP;

END Sort_SimpleSelection_Generic;
