PACKAGE BODY Tables_Generic_Hash IS
------------------------------------------------------------------------
--| Body of Generic Hash Table Package
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: February 1996                                     
------------------------------------------------------------------------

  -- these two functions are not exported to the user

  FUNCTION Hash(K: KeyType) RETURN TableIndex IS
  BEGIN -- stub
    RETURN TableIndex'First;
  END Hash;
  
  FUNCTION Increment(I: TableIndex) RETURN TableIndex IS
  BEGIN -- stub
    RETURN TableIndex'First;
  END Increment;

  FUNCTION Available(T: TableType; Probe: TableIndex) RETURN Boolean IS
  BEGIN
    RETURN T.Data(Probe).Occupied /= CurrentlyOccupied;
  END Available;
  
  FUNCTION NeverOccupied(T: TableType; Probe: TableIndex) RETURN Boolean IS
  BEGIN
    RETURN T.Data(Probe).Occupied = NeverOccupied;
  END NeverOccupied;
  
  -- exported operations

  PROCEDURE Search (Table   : TableType;
                    Target  : KeyType;
                    Success : OUT Boolean) IS

    ProperHome: TableIndex;
    Probe     : TableIndex;
    TempKey   : KeyType;
    
  BEGIN -- Search
    ProperHome := Hash(Target);
    Probe := ProperHome;
    
    LOOP
      TempKey := KeyOf(Table.Data(Probe).Info);
      IF TempKey = Target THEN
        Success := True;
        EXIT;
      ELSIF NeverOccupied(Table, Probe) THEN
        Success := False;
        EXIT;
      ELSE
        Probe := Increment(Probe);
        IF Probe = ProperHome THEN
          Success := False;
          EXIT;
        END IF; 
      END IF;
    END LOOP;
    
  END Search;
     
  PROCEDURE Insert (Table   : IN OUT TableType;
                    Item    : Element;
                    Success : OUT Boolean) IS

    ProperHome: TableIndex;
    Probe     : TableIndex;
    Target    : KeyType;
  
  BEGIN -- Insert
    Target := KeyOf (Item);
    ProperHome := Hash(Target);
    Probe := ProperHome;
    LOOP
      EXIT WHEN Available(Table, Probe);
      Probe := Increment(Probe);
      IF Probe = ProperHome THEN
        RAISE NoSpaceLeft;
      END IF;
    END LOOP;
    Table.Data(Probe) := 
      (Info => Item, Occupied => CurrentlyOccupied);
  END Insert;
  
  PROCEDURE InitializeTable (Table : IN OUT TableType) IS 
  BEGIN -- stub
    NULL;
  END InitializeTable;
     
  FUNCTION SizeOfTable (Table : TableType) RETURN Natural IS
  BEGIN -- stub
    RETURN 0;
  END SizeOfTable;

  PROCEDURE Delete (Table   : IN OUT TableType;
                    Target  : KeyType;
                    Success : OUT Boolean) IS
  BEGIN -- stub
    NULL;
  END Delete;
     
  PROCEDURE Replace (Table   : IN OUT TableType;
                     Item    : Element;
                     Success : OUT Boolean) IS
  BEGIN -- stub
    NULL;
  END Replace;
     
  PROCEDURE Retrieve (Table   : TableType;
                      Target  : KeyType;
                      Item    : OUT Element;
                      Success : OUT Boolean) IS
  BEGIN -- stub
    NULL;
  END Retrieve;

  PROCEDURE Traverse (Table : TableType) IS
  BEGIN -- stub
    NULL;
  END Traverse;

END Tables_Generic_Hash;
