PACKAGE BODY Stacks_Generic IS

  PROCEDURE MakeEmpty (S : IN OUT Stack) IS
  BEGIN
    S.latest := 0;
  END MakeEmpty;

  FUNCTION IsEmpty (S : IN Stack) RETURN Boolean IS
  BEGIN
    RETURN S.Latest = 0;
  END IsEmpty;

  FUNCTION IsFull (S : IN Stack) RETURN Boolean IS
  BEGIN
    RETURN S.Latest = S.Capacity;
  END IsFull;

  PROCEDURE Push (S : IN OUT Stack;
    E : IN Element) IS
  BEGIN
    IF IsFull (S) THEN
      RAISE StackFull;
    ELSE
      S.Latest := S.Latest + 1;
      S.Store (S.Latest) := E;
    END IF;
  END Push;

  PROCEDURE Pop (S : IN OUT Stack) IS
  BEGIN
    IF IsEmpty (S) THEN
      RAISE StackEmpty;
    ELSE
      S.Latest := S.Latest - 1;
    END IF;
  END Pop;

  FUNCTION Top (S : IN Stack) RETURN Element IS
  BEGIN
    IF IsEmpty (S) THEN
      RAISE StackEmpty;
    ELSE
      RETURN S.Store (S.Latest);
    END IF;
  END Top;

END Stacks_Generic;
