PACKAGE Singly_Linked_Lists IS
------------------------------------------------------------------
--| specification for simple linked lists with a single pointer
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: September 1995                                     
------------------------------------------------------------------

  SUBTYPE WordType IS String(1..3);

  TYPE List IS PRIVATE;

  PROCEDURE AddToFront (L: IN OUT List; Word: IN WordType);
  -- Pre:  Word is defined; L may be empty
  -- Post: Word is inserted at the beginning of L
 
  PROCEDURE AddToEnd (L: IN OUT List; Word: IN WordType);
  -- Pre:  Word is defined; L may be empty
  -- Post: Word is appended to the end of L
 
  FUNCTION Copy(L: IN List) RETURN List;
  -- Pre:  L may be empty
  -- Post: returns a complete copy of the list L

  PROCEDURE Traverse(L: IN List);
  -- Pre:  L may be empty
  -- Post: displays the contents of L's Word fields, in the 
  --   order in which they appear in L

PRIVATE

  TYPE ListNode;
  TYPE List IS ACCESS ListNode;
  TYPE ListNode IS RECORD
    Word: WordType := "###";
    Next: List;
  END RECORD;

END Singly_Linked_Lists;
