PACKAGE BODY Metric_System IS
------------------------------------------------------------------
--| This is the implementation of the package Metric_System.
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: September 1995                                     
------------------------------------------------------------------
 
  -- local function to check whether its arguments have the same dimensions

  FUNCTION SameDimensions(Left, Right :Metric) RETURN Boolean IS
  BEGIN
    RETURN (Left.Length = Right.Length) AND
           (Left.Mass = Right.Mass)     AND
           (Left.Time = Right.Time);
  END SameDimensions;

  FUNCTION "*" (Left : Float; Right : Metric) RETURN Metric IS
  BEGIN
    RETURN (Right.Mass, Right.Length, Right.Time, Left * Right.Value);
  END "*";
 
  FUNCTION Value(Left : Metric) RETURN Float IS
  BEGIN
    RETURN Left.Value;
  END Value;

  -- comparison operators

  FUNCTION "<" (Left, Right : Metric) RETURN Boolean IS
  BEGIN
    IF SameDimensions(Left, Right) THEN
      RETURN Left.Value < Right.Value;
    ELSE
      RAISE Dimension_Error;
    END IF;
  END "<";

  FUNCTION "<=" (Left, Right : Metric) RETURN Boolean IS
  BEGIN
    IF SameDimensions(Left, Right) THEN
      RETURN Left.Value <= Right.Value;
    ELSE
      RAISE Dimension_Error;
    END IF;
  END "<=";

  FUNCTION ">" (Left, Right : Metric) RETURN Boolean IS
  BEGIN
    IF SameDimensions(Left, Right) THEN
      RETURN Left.Value > Right.Value;
    ELSE
      RAISE Dimension_Error;
    END IF;
  END ">";

  FUNCTION ">=" (Left, Right : Metric) RETURN Boolean IS
  BEGIN
    IF SameDimensions(Left, Right) THEN
      RETURN Left.Value >= Right.Value;
    ELSE
      RAISE Dimension_Error;
    END IF;
  END ">=";

  --  monadic arithmetic operators
 
  FUNCTION "+" (Right : Metric) RETURN Metric IS
  BEGIN
    RETURN Right;
  END "+";
 
  FUNCTION "-" (Right : Metric) RETURN Metric IS
  BEGIN
    RETURN (Right.Mass, Right.Length, Right.Time, -Right.Value);
  END "-";
 
  FUNCTION "ABS" (Right : Metric) RETURN Metric IS
  BEGIN
    RETURN (Right.Mass, Right.Length, Right.Time, ABS(Right.Value));
  END "ABS";
 
  --  dyadic arithmetic operators
 
  --  "+" and "-" require two variables of the same subtype,
  --  they return a variable of the same subtype passed
 
  FUNCTION "+" (Left, Right : Metric) RETURN Metric IS
  BEGIN
    IF SameDimensions(Left, Right) THEN
      RETURN (Left.Mass, Left.Length, Left.Time, Left.Value + Right.Value);
    ELSE
      RAISE Dimension_Error;
    END IF;
  END "+";
 
  FUNCTION "-" (Left, Right : Metric) RETURN Metric IS
  BEGIN
    IF SameDimensions(Left, Right) THEN
      RETURN (Left.Mass, Left.Length, Left.Time, Left.Value - Right.Value);
    ELSE
      RAISE Dimension_Error;
    END IF;
  END "-";

  --  "*" and "/" require variables of any subtype
  --  of Metric.  The subtype of the variable returned depends on
  --  the types passed and how the operation combines the units.
 
  FUNCTION "*" (Left, Right : Metric) RETURN Metric IS
  BEGIN
    RETURN (Left.Mass + Right.Mass, Left.Length + Right.Length, 
            Left.Time + Right.Time, Left.Value * Right.Value);
  END "*";
 
  FUNCTION "/" (Left, Right : Metric) RETURN Metric IS
  BEGIN
    RETURN (Left.Mass - Right.Mass, Left.Length - Right.Length, 
            Left.Time - Right.Time, Left.Value / Right.Value);
  END "/";
 
END Metric_System;
