WITH Types; USE Types;
PACKAGE Database IS
------------------------------------------------------------------------
--| Maintains bank's internal data about open accounts and balances
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: January 1996                                     
------------------------------------------------------------------------

  PROTECTED Manager IS

    -- All these procedures are protected, so only one call at a time
    -- will be executed, even if the calls arrive concurrently.
    
    PROCEDURE EnterCustID (ID : OUT CustID; Stat  : OUT Status);
    -- Pre:  None
    -- Post: ID is the next available customer ID; Stat is OK.

    PROCEDURE Deposit (ID : IN CustID; Amount : IN Money;
                       NewBalance : OUT Money; Stat : OUT Status); 
    -- Pre:  ID and Amount are defined
    -- Post: If ID is valid, NewBalance is the resulting balance
    --       and Stat is OK; otherwise, Stat is BadCustID.

    PROCEDURE Withdraw (ID : IN CustID; Amount : IN Money;
                         NewBalance : OUT Money; Stat : OUT Status); 
    -- Pre:  ID and Amount are defined
    -- Post: If ID is valid and NewBalance would be nonnegative,
    --       Stat is OK and NewBalance is returned.
    --       If ID is invalid, Stat is BadCustID; if NewBalance 
    --       would be negative, Stat is InsufficientFunds

    PROCEDURE Balance (ID : IN CustID; Amount : OUT Money;
                       Stat : OUT Status); 
    -- Pre:  ID is defined
    -- Post: If ID is invalid, Stat is BadCustID; otherwise,
    --       Stat is OK and Amount is current balance
  END Manager;

END Database;
