WITH Ada.Text_IO;
WITH Chop;
WITH Phil;
WITH Society;
WITH Calendar;
PRAGMA Elaborate (Phil);
PACKAGE BODY Room IS
------------------------------------------------------------------------
--| Dining Philosophers, Ada 95 edition
--| A line-oriented version of the Room package
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: January 1996                                     
------------------------------------------------------------------------

  -- philosophers sign into dining room, giving Maitre_D their DNA code
 
  Dijkstra  : ALIASED Phil.Philosopher (My_ID => 1);
  Burns     : ALIASED Phil.Philosopher (My_ID => 2);
  Anderson  : ALIASED Phil.Philosopher (My_ID => 3);
  Ichbiah   : ALIASED Phil.Philosopher (My_ID => 4);
  Taft      : ALIASED Phil.Philosopher (My_ID => 5);
 
  TYPE Philosopher_Ptr IS ACCESS ALL Phil.Philosopher;
  Phils : ARRAY (Table_Type) OF Philosopher_Ptr;

  TASK BODY Maitre_D IS
 
    T          : Natural;
    Start_Time : Calendar.Time;
    Blanks : CONSTANT String := "     ";

  BEGIN
 
    ACCEPT Start_Serving;
    Ada.Text_IO.New_Line;
    Ada.Text_IO.Put_Line ("Ada 95 Philosophical Society is Open for Business!");

    Start_Time := Calendar.Clock;
 
    -- now Maitre_D assigns phils to seats at the table

    Phils :=
      (Dijkstra'Access,
       Anderson'Access,
       Taft'Access,
       Ichbiah'Access,
       Burns'Access);
  
    -- and assigns them their chopsticks.

    Phils (1).Start_Eating (1, 2);
    Phils (3).Start_Eating (3, 4);
    Phils (2).Start_Eating (2, 3);
    Phils (5).Start_Eating (1, 5);
    Phils (4).Start_Eating (4, 5);
 
    LOOP
      SELECT
        ACCEPT Report_State (Which_Phil : IN Society.Unique_DNA_Codes;
                             State      : IN Phil.States;
                             How_Long   : IN Natural := 0;
                             Which_Meal : IN Natural := 0) do

          T := Natural (Calendar."-" (Calendar.Clock, Start_Time));
 
          CASE State IS
 
            WHEN Phil.Breathing =>
              Ada.Text_IO.Put_Line ("T =" & Integer'Image (T) & " " 
                      & Blanks(1..Which_Phil)
                      & Society.Name_Register(Which_Phil)
                      & "Breathing");
            WHEN Phil.Thinking =>
              Ada.Text_IO.Put_Line ("T =" & Integer'Image (T) & " " 
                      & Blanks(1..Which_Phil)
                      & Society.Name_Register(Which_Phil)
                      & "Thinking" 
                      & Integer'Image (How_Long) & " seconds.");
            WHEN Phil.Eating =>
              Ada.Text_IO.Put_Line ("T =" & Integer'Image (T) & " " 
                      & Blanks(1..Which_Phil)
                      & Society.Name_Register(Which_Phil)
                      & "Eating meal"  
                      & Integer'Image (Which_Meal)
                      & " for"
                      & Integer'Image (How_Long) & " seconds.");
            WHEN Phil.Done_Eating =>
              Ada.Text_IO.Put_Line ("T =" & Integer'Image (T) & " " 
                      & Blanks(1..Which_Phil)
                      & Society.Name_Register(Which_Phil)
                      & "Yum-yum (burp)");
            WHEN Phil.Got_One_Stick =>
              Ada.Text_IO.Put_Line ("T =" & Integer'Image (T) & " " 
                      & Blanks(1..Which_Phil)
                      & Society.Name_Register(Which_Phil)
                      & "First chopstick" 
                      & Integer'Image (How_Long));
            WHEN Phil.Got_Other_Stick =>
              Ada.Text_IO.Put_Line ("T =" & Integer'Image (T) & " " 
                      & Blanks(1..Which_Phil)
                      & Society.Name_Register(Which_Phil)
                      & "Second chopstick" 
                      & Integer'Image (How_Long));
            WHEN Phil.Dying =>
              Ada.Text_IO.Put_Line ("T =" & Integer'Image (T) & " " 
                      & Blanks(1..Which_Phil)
                      & Society.Name_Register(Which_Phil)
                      & "Croak");
 
          END CASE; -- State
          
        END Report_State;
 
      OR
        TERMINATE;
      END SELECT;
 
    END LOOP;
 
  END Maitre_D;
 
END Room;
